/* eslint-disable */
/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */

/**
 * The type of the evaluation
 */
export type EvalTypeID = string;
/**
 * random seed
 */
export type RandomSeed = number;
/**
 * List of dataset names for both the SCR and TPP metrics
 */
export type DatasetNames = string[];
/**
 * If True, the eval will be Spurious Correlation Removal (SCR). If False, the eval will be TPP.
 */
export type PerformSpuriousCorrelationRemoval = boolean;
/**
 * We set early stopping patience to probe epochs, so we always train for the same amount.
 */
export type EarlyStoppingPatience = number;
/**
 * Train set size for each linear probe.
 */
export type TrainSetSize = number;
/**
 * Test set size for each linear probe.
 */
export type TestSetSize = number;
/**
 * The maximum length of each input to the LLM. Any longer inputs will be truncated, keeping only the beginning.
 */
export type LLMContextLength = number;
/**
 * DO NOT CHANGE without reading the paper appendix Section 1. The probe's train batch size effects the size of the spuriour correlation learned by the probe.
 */
export type ProbeTrainBatchSize = number;
/**
 * Batch size when testing the linear probe
 */
export type ProbeTestBatchSize = number;
/**
 * Number of epochs to train the linear probe. Many epochs are needed to decrease randomness in the SCR results.
 */
export type ProbeEpochs = number;
/**
 * Probe learning rate.
 */
export type ProbeLR = number;
/**
 * L1 sparsity penalty when training the linear probe.
 */
export type ProbeL1Penalty = number;
/**
 * SAE Batch size, inference only
 */
export type SAEBatchSize = number;
/**
 * LLM batch size. This is set by default in the main script, or it can be set with a command line argument.
 */
export type LLMBatchSize = number;
/**
 * LLM data type. This is set by default in the main script, or it can be set with a command line argument.
 */
export type LLMDataType = string;
/**
 * Lower GPU memory usage by moving model to CPU when not required. Will be slower and require more system memory.
 */
export type LowerMemoryUsage = boolean;
/**
 * Model name. Must be set with a command line argument.
 */
export type ModelName = string;
/**
 * N represents the number of features we zero ablate when performing SCR or TPP. We iterate over all values of N.
 */
export type NValues = number[];
/**
 * A unique UUID identifying this specific eval run
 */
export type ID = string;
/**
 * The datetime of the evaluation in epoch milliseconds
 */
export type DateTimeEpochMs = number;
/**
 * Ablating the top 2 gender latents to increase profession accuracy
 */
export type SCRDir1Top2SAELatents = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 2 SAE latents
 */
export type SCRMetricTop2SAELatents = number | null;
/**
 * Ablating the top 2 profession latents to increase gender accuracy
 */
export type SCRDir2Top2SAELatents = number | null;
/**
 * Ablating the top 5 gender latents to increase profession accuracy
 */
export type SCRDir1Top5SAELatents = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 5 SAE latents
 */
export type SCRMetricTop5SAELatents = number | null;
/**
 * Ablating the top 5 profession latents to increase gender accuracy
 */
export type SCRDir2Top5SAELatents = number | null;
/**
 * Ablating the top 10 gender latents to increase profession accuracy
 */
export type SCRDir1Top10SAELatents = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 10 SAE latents
 */
export type SCRMetricTop10SAELatents = number | null;
/**
 * Ablating the top 10 profession latents to increase gender accuracy
 */
export type SCRDir2Top10SAELatents = number | null;
/**
 * Ablating the top 20 gender latents to increase profession accuracy
 */
export type SCRDir1Top20SAELatents = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 20 SAE latents
 */
export type SCRMetricTop20SAELatents = number | null;
/**
 * Ablating the top 20 profession latents to increase gender accuracy
 */
export type SCRDir2Top20SAELatents = number | null;
/**
 * Ablating the top 50 gender latents to increase profession accuracy
 */
export type SCRDir1Top50SAELatents = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 50 SAE latents
 */
export type SCRMetricTop50SAELatents = number | null;
/**
 * Ablating the top 50 profession latents to increase gender accuracy
 */
export type SCRDir2Top50SAELatents = number | null;
/**
 * Ablating the top 100 gender latents to increase profession accuracy
 */
export type SCRDir1Top100SAELatents = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 100 SAE latents
 */
export type SCRMetricTop100SAELatents = number | null;
/**
 * Ablating the top 100 profession latents to increase gender accuracy
 */
export type SCRDir2Top100SAELatents = number | null;
/**
 * Ablating the top 500 gender latents to increase profession accuracy
 */
export type SCRDir1Top500SAELatents = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 500 SAE latents
 */
export type SCRMetricTop500SAELatents = number | null;
/**
 * Ablating the top 500 profession latents to increase gender accuracy
 */
export type SCRDir2Top500SAELatents = number | null;
export type DatasetName = string;
/**
 * Ablating the top 2 gender latents to increase profession accuracy
 */
export type SCRDir1Top2SAELatents1 = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 2 SAE latents
 */
export type SCRMetricTop2SAELatents1 = number | null;
/**
 * Ablating the top 2 profession latents to increase gender accuracy
 */
export type SCRDir2Top2SAELatents1 = number | null;
/**
 * Ablating the top 5 gender latents to increase profession accuracy
 */
export type SCRDir1Top5SAELatents1 = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 5 SAE latents
 */
export type SCRMetricTop5SAELatents1 = number | null;
/**
 * Ablating the top 5 profession latents to increase gender accuracy
 */
export type SCRDir2Top5SAELatents1 = number | null;
/**
 * Ablating the top 10 gender latents to increase profession accuracy
 */
export type SCRDir1Top10SAELatents1 = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 10 SAE latents
 */
export type SCRMetricTop10SAELatents1 = number | null;
/**
 * Ablating the top 10 profession latents to increase gender accuracy
 */
export type SCRDir2Top10SAELatents1 = number | null;
/**
 * Ablating the top 20 gender latents to increase profession accuracy
 */
export type SCRDir1Top20SAELatents1 = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 20 SAE latents
 */
export type SCRMetricTop20SAELatents1 = number | null;
/**
 * Ablating the top 20 profession latents to increase gender accuracy
 */
export type SCRDir2Top20SAELatents1 = number | null;
/**
 * Ablating the top 50 gender latents to increase profession accuracy
 */
export type SCRDir1Top50SAELatents1 = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 50 SAE latents
 */
export type SCRMetricTop50SAELatents1 = number | null;
/**
 * Ablating the top 50 profession latents to increase gender accuracy
 */
export type SCRDir2Top50SAELatents1 = number | null;
/**
 * Ablating the top 100 gender latents to increase profession accuracy
 */
export type SCRDir1Top100SAELatents1 = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 100 SAE latents
 */
export type SCRMetricTop100SAELatents1 = number | null;
/**
 * Ablating the top 100 profession latents to increase gender accuracy
 */
export type SCRDir2Top100SAELatents1 = number | null;
/**
 * Ablating the top 500 gender latents to increase profession accuracy
 */
export type SCRDir1Top500SAELatents1 = number | null;
/**
 * SCR Metric (selecting dir1 if inital profession accuracy is lower than initial gender accuracy, else dir2) ablating the top 500 SAE latents
 */
export type SCRMetricTop500SAELatents1 = number | null;
/**
 * Ablating the top 500 profession latents to increase gender accuracy
 */
export type SCRDir2Top500SAELatents1 = number | null;
/**
 * Each object is a stat on the SCR results for a single dataset.
 */
export type PerDatasetSpuriousCorrelationRemovalSCRResults = ScrResultDetail[];
/**
 * The commit hash of the SAE Bench that ran the evaluation.
 */
export type SAEBenchCommitHash = string;
/**
 * The ID of the SAE in SAE Lens.
 */
export type SAELensID = string | null;
/**
 * The release ID of the SAE in SAE Lens.
 */
export type SAELensReleaseID = string | null;
/**
 * The version of SAE Lens that ran the evaluation.
 */
export type SAELensVersion = string | null;
/**
 * The configuration of the SAE (custom or from SAE Lens) that ran the evaluation. This should match the SAE Lens config schema.
 */
export type SAEConfigDict = {
  [k: string]: unknown;
} | null;

/**
 * The Spurious Correlation Removal (SCR) evaluation ablates SAE latents to shift the bias of a biased linear probe. The methodology is from `Evaluating Sparse Autoencoders on Targeted Concept Removal Tasks`.
 */
export interface SCR {
  eval_type_id?: EvalTypeID;
  eval_config: EvalConfigType;
  eval_id: ID;
  datetime_epoch_millis: DateTimeEpochMs;
  eval_result_metrics: ResultMetricsCategorized;
  eval_result_details?: PerDatasetSpuriousCorrelationRemovalSCRResults;
  sae_bench_commit_hash: SAEBenchCommitHash;
  sae_lens_id: SAELensID;
  sae_lens_release_id: SAELensReleaseID;
  sae_lens_version: SAELensVersion;
  sae_cfg_dict: SAEConfigDict;
  eval_result_unstructured?: unknown;
  [k: string]: unknown;
}
/**
 * The configuration of the evaluation.
 */
export interface EvalConfigType {
  random_seed?: RandomSeed;
  dataset_names?: DatasetNames;
  perform_scr?: PerformSpuriousCorrelationRemoval;
  early_stopping_patience?: EarlyStoppingPatience;
  train_set_size?: TrainSetSize;
  test_set_size?: TestSetSize;
  context_length?: LLMContextLength;
  probe_train_batch_size?: ProbeTrainBatchSize;
  probe_test_batch_size?: ProbeTestBatchSize;
  probe_epochs?: ProbeEpochs;
  probe_lr?: ProbeLR;
  probe_l1_penalty?: ProbeL1Penalty;
  sae_batch_size?: SAEBatchSize;
  llm_batch_size?: LLMBatchSize;
  llm_dtype?: LLMDataType;
  lower_vram_usage?: LowerMemoryUsage;
  model_name?: ModelName;
  n_values?: NValues;
  column1_vals_lookup?: Column1ValuesLookup;
  [k: string]: unknown;
}
/**
 * Column1 Values apply only to the SCR metric. Column1 values represents the class pairs we train the linear probes on. In each case, we will create a perfectly biased dataset, such as all professors are males and all nurses are females.
 */
export interface Column1ValuesLookup {
  [k: string]: [unknown, unknown][];
}
/**
 * The metrics of the evaluation, organized by category. Define your own categories and the metrics that go inside them.
 */
export interface ResultMetricsCategorized {
  scr_metrics: SCRMetrics;
  [k: string]: unknown;
}
/**
 * SCR metrics, calculated for different numbers of ablated features. Also includes the results for both correlation removal directions.
 */
export interface SCRMetrics {
  scr_dir1_threshold_2?: SCRDir1Top2SAELatents;
  scr_metric_threshold_2?: SCRMetricTop2SAELatents;
  scr_dir2_threshold_2?: SCRDir2Top2SAELatents;
  scr_dir1_threshold_5?: SCRDir1Top5SAELatents;
  scr_metric_threshold_5?: SCRMetricTop5SAELatents;
  scr_dir2_threshold_5?: SCRDir2Top5SAELatents;
  scr_dir1_threshold_10?: SCRDir1Top10SAELatents;
  scr_metric_threshold_10?: SCRMetricTop10SAELatents;
  scr_dir2_threshold_10?: SCRDir2Top10SAELatents;
  scr_dir1_threshold_20?: SCRDir1Top20SAELatents;
  scr_metric_threshold_20?: SCRMetricTop20SAELatents;
  scr_dir2_threshold_20?: SCRDir2Top20SAELatents;
  scr_dir1_threshold_50?: SCRDir1Top50SAELatents;
  scr_metric_threshold_50?: SCRMetricTop50SAELatents;
  scr_dir2_threshold_50?: SCRDir2Top50SAELatents;
  scr_dir1_threshold_100?: SCRDir1Top100SAELatents;
  scr_metric_threshold_100?: SCRMetricTop100SAELatents;
  scr_dir2_threshold_100?: SCRDir2Top100SAELatents;
  scr_dir1_threshold_500?: SCRDir1Top500SAELatents;
  scr_metric_threshold_500?: SCRMetricTop500SAELatents;
  scr_dir2_threshold_500?: SCRDir2Top500SAELatents;
  [k: string]: unknown;
}
export interface ScrResultDetail {
  dataset_name: DatasetName;
  scr_dir1_threshold_2?: SCRDir1Top2SAELatents1;
  scr_metric_threshold_2?: SCRMetricTop2SAELatents1;
  scr_dir2_threshold_2?: SCRDir2Top2SAELatents1;
  scr_dir1_threshold_5?: SCRDir1Top5SAELatents1;
  scr_metric_threshold_5?: SCRMetricTop5SAELatents1;
  scr_dir2_threshold_5?: SCRDir2Top5SAELatents1;
  scr_dir1_threshold_10?: SCRDir1Top10SAELatents1;
  scr_metric_threshold_10?: SCRMetricTop10SAELatents1;
  scr_dir2_threshold_10?: SCRDir2Top10SAELatents1;
  scr_dir1_threshold_20?: SCRDir1Top20SAELatents1;
  scr_metric_threshold_20?: SCRMetricTop20SAELatents1;
  scr_dir2_threshold_20?: SCRDir2Top20SAELatents1;
  scr_dir1_threshold_50?: SCRDir1Top50SAELatents1;
  scr_metric_threshold_50?: SCRMetricTop50SAELatents1;
  scr_dir2_threshold_50?: SCRDir2Top50SAELatents1;
  scr_dir1_threshold_100?: SCRDir1Top100SAELatents1;
  scr_metric_threshold_100?: SCRMetricTop100SAELatents1;
  scr_dir2_threshold_100?: SCRDir2Top100SAELatents1;
  scr_dir1_threshold_500?: SCRDir1Top500SAELatents1;
  scr_metric_threshold_500?: SCRMetricTop500SAELatents1;
  scr_dir2_threshold_500?: SCRDir2Top500SAELatents1;
  [k: string]: unknown;
}
